
(* 2x1 flyways w/ 2 xbots - async,async velocity, create group,block&release group buffer, bond&unbond group *)
FUNCTION_BLOCK Example03_groups
	(*async move to 60,60 and 60,180*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;
	PosX_array78[0] := 0.06;PosX_array78[1] := 0.06;
	PosY_array78[0] := 0.06;PosY_array78[1] := 0.18;
	PMC_AutoDrivingMotion1(PM_Controller := PM_Controller,Execute := Execute,nXbots := 2,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := PosX_array78,PosY := PosY_array78);

	(* create group 1 w/ xbots 1 and 2*)
	xbotID_array32[0] := 1;xbotID_array32[1] := 2;
	PMC_CreateXbotGroup1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotion1.Done,GroupID := 1,nXbots := 2,XbotID := xbotID_array32);

	(*block buffer for group 1*)
	PMC_BlockXbotGroup1(PM_Controller := PM_Controller,Execute := PMC_CreateXbotGroup1.Done,GroupID := 1,IsBlock := TRUE);

	(* load command to move xbot 1 to 420,60*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := PMC_BlockXbotGroup1.Done,cmdLB := 4,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*load command to move xbot 2 to 420,180*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Ack,cmdLB := 5,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*release buffer for group 1*)
	PMC_BlockXbotGroup2(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Ack,GroupID := 1,IsBlock := FALSE);

	(*move xbot 1 to 60,60*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_BlockXbotGroup2.Done AND PMC_XYMotion2.Done,cmdLB := 7,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.06,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(* async move to 180,60 and 180,180 at user set speed and acceleration*)
	xbotID_array78[0] := 1;xbotID_array78[1] := 2;
	PosX_array78[0] := 0.180;PosX_array78[1] := 0.060;
	PosY_array78[0] := 0.180;PosY_array78[1] := 0.180;
	PMC_AutoDrivingMotionVelocity1(PM_Controller := PM_Controller,Execute := PMC_XYMotion3.Done,nXbots := 2,RoutingType := 0,ZoneID := 0,XbotID := xbotID_array78,PosX := PosX_array78,PosY := PosY_array78,MaxVel := 2,MaxAcc := 20);

	(* bond xbots in group 1*)
	PMC_BondXbotGroup1(PM_Controller := PM_Controller,Execute := PMC_AutoDrivingMotionVelocity1.Done,GroupID := 1,IsBond := TRUE,Mode := 0);

	(* move xbot 1 to 420,60*)
	PMC_XYMotion4(PM_Controller := PM_Controller,Execute := PMC_BondXbotGroup1.Done,cmdLB := 10,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.42,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*move xbot 2 to 300,180*)
	PMC_XYMotion5(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Done,cmdLB := 11,XbotID := 2,Mode := 0,Type_ := 0,PosX := 0.3,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*move xbot 1 to 180,60*)
	PMC_XYMotion6(PM_Controller := PM_Controller,Execute := PMC_XYMotion5.Done,cmdLB := 12,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.18,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*unbond xbots in group 1*)
	PMC_BondXbotGroup2(PM_Controller := PM_Controller,Execute := PMC_XYMotion6.Done,GroupID := 1,IsBond := FALSE,Mode := 0);

	(*move xbot 1 to 180,180*)
	PMC_XYMotion7(PM_Controller := PM_Controller,Execute := PMC_BondXbotGroup2.Done,cmdLB := 14,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.18,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*delete group 1*)
	PMC_DeleteXbotGroup1(PM_Controller := PM_Controller,Execute := PMC_XYMotion7.Done,GroupID := 1);
	
	Done := PMC_DeleteXbotGroup1.Done;
END_FUNCTION_BLOCK
